//###############################################################
//
//	Cruise.cpp : implementation file
//
//	S_CruiseIDToNum(UINT ID,LPTSTR *IDBName)
//	S_Cruise_ChooseParaFromFile(UINT CruiseNum)
//	S_Cruise_ReadFileToEE(UINT	CruiseNum)
//###############################################################

#include "stdafx.h"
#include "Define.h"
#include "winuser.h"
#include "resource.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "CruiseDlg.h"
#include "misc.h"
#include "comm.h"
#include "Cruise.h"
#include "misc.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//---------------------------------------------------------------
//extern	CCruiseDlg		*G_CruiseDlg;


//###############################################################
//
// UINT S_CruiseIDToNum(UINT ID)
//
// ID : Sequence point ID
//###############################################################
UINT CCruise::S_CruiseIDToNum(UINT ID,LPTSTR *IDBName)
{
UINT	Num=0;
UINT	IDBBuffer[9]=
		{	IDB_SQ_CRUISE_DOMED,IDB_SQ_CRUISE_NUM1D,IDB_SQ_CRUISE_NUM2D,
			IDB_SQ_CRUISE_NUM3D,IDB_SQ_CRUISE_NUM4D,IDB_SQ_CRUISE_NUM5D,
			IDB_SQ_CRUISE_NUM6D,IDB_SQ_CRUISE_NUM7D,IDB_SQ_CRUISE_NUM8D	};

switch(ID)
	{
	case IDC_CRUISE_DOME: Num=0;	break;
	case IDC_CRUISE_NUM1: Num=1;	break;
	case IDC_CRUISE_NUM2: Num=2;	break;
	case IDC_CRUISE_NUM3: Num=3;	break;
	case IDC_CRUISE_NUM4: Num=4;	break;
	case IDC_CRUISE_NUM5: Num=5;	break;
	case IDC_CRUISE_NUM6: Num=6;	break;
	case IDC_CRUISE_NUM7: Num=7;	break;
	}

*IDBName=MAKEINTRESOURCE( IDBBuffer[Num] );

return(Num);
}


//###############################################################
//
//	S_Cruise_ChooseParaFromFile()
//
//###############################################################

void	CCruise::S_Cruise_ChooseParaFromFile(UINT CruiseNum)
{
HANDLE			hMapTemp,hMapRec;
unsigned char 	*FptrTemp,*FptrRec;
DWORD			FileLength;
UINT			FilePos=0;
CFile			hCruiseTemp,hCruiseRec;
CFileException	fileException;
UINT			NumInTemp=0;
unsigned int	i,j,k;
unsigned short 	PanDeg1=0,TiltDeg1=0;
unsigned short	PanDeg2=0,TiltDeg2=0;
unsigned short	dPanDeg=0,dTiltDeg=0;


//------------- Open file for read ---------------------------------------
if ( !hCruiseTemp.Open( "Cruise.tmp", CFile::modeRead, &fileException ) )
	{
	::MessageBox(G_CruiseDlg->m_hWnd,"Can't open file Cruise.tmp",NULL,
					MB_OK|MB_ICONEXCLAMATION);
	}
hMapTemp=CreateFileMapping((void *)hCruiseTemp.m_hFile ,NULL,PAGE_READONLY,0,0,NULL);
FptrTemp=(unsigned char *)MapViewOfFile(hMapTemp,FILE_MAP_READ,0,0,0);
//------------- Open file for write -------------------------------------
if ( !hCruiseRec.Open( "Cruise.rec", CFile::modeReadWrite, &fileException ) )
	{
	::MessageBox(G_CruiseDlg->m_hWnd,"Can't open file Cruise.rec",NULL,
					MB_OK|MB_ICONEXCLAMATION);
	}
hMapRec=CreateFileMapping( (void *)hCruiseRec.m_hFile,NULL,PAGE_READWRITE,0,0,NULL);
FptrRec=(unsigned char *)MapViewOfFile(hMapRec,FILE_MAP_WRITE,0,0,0);
//---------- Get point number in file --------------------
FileLength=hCruiseTemp.GetLength();
NumInTemp=FileLength/5;
//---------- Choose point para write to Rec. file --------
FilePos=(CruiseNum-1)*AVL_NUM_CRUISE*EE_SIZE_CRUISE;

if (NumInTemp<=AVL_NUM_CRUISE)
	{//-----------------------------------------------------------
	for ( j=0;j<=(AVL_NUM_CRUISE-1);j++ )
		{
		if( j<=(NumInTemp-1) )
			{
			for( i=0;i<=4;i++)
				*(FptrRec+FilePos+j*EE_SIZE_CRUISE+i)=*(FptrTemp+j*5+i);
			//-----------------------------------------------
			PanDeg2=S_WORD( *(FptrTemp+j*5),*(FptrTemp+1+j*5) );
			TiltDeg2=S_WORD( *(FptrTemp+2+j*5),*(FptrTemp+3+j*5) );
			if(j>=1)
				{
				dPanDeg=PanDeg2-PanDeg1;
				dTiltDeg=TiltDeg2-TiltDeg1;
				*(FptrRec+FilePos+(j-1)*EE_SIZE_CRUISE+5)=0x60;	//0x60
				*(FptrRec+FilePos+(j-1)*EE_SIZE_CRUISE+6)=0x30;	//0x60
				}
			//-----------------------------------------------
			if( j==(NumInTemp-1) )
				{
				*(FptrRec+FilePos+j*EE_SIZE_CRUISE+5)=0x60;
				*(FptrRec+FilePos+j*EE_SIZE_CRUISE+6)=0x30;
				}

			PanDeg1=S_WORD( *(FptrTemp+j*5),*(FptrTemp+1+j*5) );
			TiltDeg1=S_WORD( *(FptrTemp+2+j*5),*(FptrTemp+3+j*5) );
			}
		else
			{
			//---- fill dummy data ----
			for( k=0;k<=6;k++)
				*(FptrRec+FilePos+j*EE_SIZE_CRUISE+k)=0xff;
			}
		}
	}//-----------------------------------------------------------
else
	{//------------------------------
	float	Space=0;
	UINT	ExactNum=0;

	Space=(float)NumInTemp/AVL_NUM_CRUISE;

	for ( j=0;j<=(AVL_NUM_CRUISE-1);j++ )
		{
		ExactNum=(UINT)Space*j;

		for( i=0;i<=4;i++)
			*(FptrRec+FilePos+j*EE_SIZE_CRUISE+i)=*(FptrTemp+ExactNum*5+i);
		//-----------------------------------------------
		PanDeg2=S_WORD( *(FptrTemp+j*5),*(FptrTemp+1+j*5) );
		TiltDeg2=S_WORD( *(FptrTemp+2+j*5),*(FptrTemp+3+j*5) );
		if(j>=1)
			{
			dPanDeg=PanDeg2-PanDeg1;
			dTiltDeg=TiltDeg2-TiltDeg1;
			*(FptrRec+FilePos+(j-1)*EE_SIZE_CRUISE+5)=0x60;	//0x60
			*(FptrRec+FilePos+(j-1)*EE_SIZE_CRUISE+6)=0x30;	//0x60
			}
		//-----------------------------------------------
		if( j==(NumInTemp-1) )
			{
			*(FptrRec+FilePos+j*EE_SIZE_CRUISE+5)=0x60;	
			*(FptrRec+FilePos+j*EE_SIZE_CRUISE+6)=0x30;
			}
		PanDeg1=S_WORD( *(FptrTemp+j*5),*(FptrTemp+1+j*5) );
		TiltDeg1=S_WORD( *(FptrTemp+2+j*5),*(FptrTemp+3+j*5) );

		}
	}//------------------------------
//----- Close file for read ---------
UnmapViewOfFile(FptrTemp); 
CloseHandle(hMapTemp);
hCruiseTemp.Close();
//----- Close file for write --------
FlushViewOfFile(FptrRec,0);
UnmapViewOfFile(FptrRec); 
CloseHandle(hMapRec);
hCruiseRec.Close();

}


//###############################################################
//
//	S_Cruise_ReadFileToEE()
//
//###############################################################

void	CCruise::S_Cruise_ReadFileToEE(UINT	CruiseNum)
{
HANDLE			hMapRec;
unsigned char 	*FptrRec;
CFile			hCruiseRec;
CFileException	fileException;
char			EEAddr[3];
char			Para[AVL_NUM_CRUISE*EE_SIZE_CRUISE];
UINT			FilePos=0;


//------------- Open file for read ---------------------------------------
if ( !hCruiseRec.Open( "Cruise.rec", CFile::modeRead, &fileException ) )
	{
	::MessageBox(G_CruiseDlg->m_hWnd,"Can't open file Cruise.rec for read",NULL,
					MB_OK|MB_ICONEXCLAMATION);
	}
hMapRec=CreateFileMapping((void *)hCruiseRec.m_hFile ,NULL,PAGE_READONLY,0,0,NULL);
FptrRec=(unsigned char *)MapViewOfFile(hMapRec,FILE_MAP_READ,0,0,0);

//-------------------
FilePos=(CruiseNum-1)*AVL_NUM_CRUISE*EE_SIZE_CRUISE;
for ( int i=0;i<=(AVL_NUM_CRUISE-1);i++ )
	{
	for ( int j=0;j<=(EE_SIZE_CRUISE-1);j++ )
		{
		Para[i*EE_SIZE_CRUISE+j]=
				*(FptrRec+FilePos+i*EE_SIZE_CRUISE+j);
		}
	}

WORD	Y_Addr=EE_BASE_CRUISE;
EEAddr[0]=LOBYTE(Y_Addr);
EEAddr[1]=HIBYTE(Y_Addr);

CComm::S_COM_AccessEEData(0,EEAddr,AVL_NUM_CRUISE*EE_SIZE_CRUISE,Para);
//-------------------

UnmapViewOfFile(FptrRec); 
CloseHandle(hMapRec);
hCruiseRec.Close();
}



